<?php $__env->startSection('title', 'Hitung Gaji Harian'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-4">

    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="mb-0">Hitung Gaji Harian Karyawan</h4>

        <a href="<?php echo e(route('admin.gaji.index')); ?>" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left me-1"></i> Kembali
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>


    <form action="<?php echo e(route('admin.gaji.hitung')); ?>" method="POST" class="card p-4 shadow-sm">
        <?php echo csrf_field(); ?>

        <div class="row mb-3">
            <div class="col-md-4">
                <label class="form-label">Karyawan</label>
                <select name="karyawan_id" class="form-select" required>
                    <option value="">-- Pilih Karyawan --</option>
                    <?php $__currentLoopData = $karyawan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($k->id); ?>">
                            <?php echo e($k->user->nama); ?> - <?php echo e($k->jabatan->nama_jabatan); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-4">
                <label class="form-label">Bulan</label>
<select name="bulan" class="form-select" required>
    <?php $__currentLoopData = range(1,12); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $b): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($b); ?>">
            <?php echo e(\Carbon\Carbon::create()->month($b)->locale('id')->monthName); ?>

        </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>

            </div>

            <div class="col-md-4">
                <label class="form-label">Tahun</label>
<input type="number" name="tahun"
       value="<?php echo e(now('Asia/Jakarta')->year); ?>"
       class="form-control" required>

            </div>
        </div>

        <button class="btn btn-primary">
            <i class="fas fa-calculator"></i> Hitung Gaji
        </button>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\DAVA\Documents\FILE_SEKOLAH\WEB XII\absensi-hotel - Copy\resources\views/admin/gaji/create.blade.php ENDPATH**/ ?>